/**
 * Converge Auth JS — Popup-based authentication flow.
 */
(function ($) {
  "use strict";

  var authPopup = null;

  // Connect button click handler
  $("#converge-connect").on("click", function () {
    var width = 500;
    var height = 600;
    var left = (screen.width - width) / 2;
    var top = (screen.height - height) / 2;

    authPopup = window.open(
      convergeAdmin.apiBase + "/wordpress-auth",
      "converge_auth",
      "width=" + width + ",height=" + height + ",left=" + left + ",top=" + top + ",toolbar=no,menubar=no"
    );

    // Poll for popup close (fallback if postMessage fails)
    var pollTimer = setInterval(function () {
      if (authPopup && authPopup.closed) {
        clearInterval(pollTimer);
        authPopup = null;
      }
    }, 500);
  });

  // Listen for auth message from popup
  window.addEventListener("message", function (event) {
    if (!event.data || event.data.type !== "converge-wp-auth") return;

    var accessToken = event.data.accessToken;
    var refreshToken = event.data.refreshToken;

    if (!accessToken || !refreshToken) return;

    // Close popup
    if (authPopup) {
      authPopup.close();
      authPopup = null;
    }

    // Save tokens via AJAX
    $.post(convergeAdmin.ajaxUrl, {
      action: "converge_save_auth",
      nonce: convergeAdmin.nonce,
      access_token: accessToken,
      refresh_token: refreshToken,
    }).done(function (response) {
      if (response.success) {
        // Reload to show connected state
        location.reload();
      } else {
        alert("Failed to save connection. Please try again.");
      }
    }).fail(function () {
      alert("Connection failed. Please try again.");
    });
  });
})(jQuery);
