<?php
/**
 * Plugin Name: Converge — Apply by Voice
 * Plugin URI: https://www.convergehiring.com/wordpress
 * Description: Replace resumes and phone screens with structured voice conversations.
 * Version: 1.0.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Converge Hiring
 * Author URI: https://www.convergehiring.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: converge-applybyvoice
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'CONVERGE_VERSION', '1.0.0' );
define( 'CONVERGE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CONVERGE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'CONVERGE_API_BASE', 'https://www.convergehiring.com' );
define( 'CONVERGE_CANDIDATE_BASE', 'https://applybyvoice.com' );

/**
 * Initialize plugin on plugins_loaded.
 */
function converge_init() {
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-auth.php';
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-api.php';
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-admin.php';
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-sync.php';
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-cron.php';
    require_once CONVERGE_PLUGIN_DIR . 'includes/class-converge-frontend.php';

    $auth  = new Converge_Auth();
    $api   = new Converge_API( $auth );
    $sync  = new Converge_Sync( $api );
    new Converge_Cron( $auth, $sync );
    new Converge_Admin( $auth, $api, $sync );
    new Converge_Frontend( $auth );
}
add_action( 'plugins_loaded', 'converge_init' );

/**
 * Activation hook.
 */
function converge_activate() {
    add_option( 'converge_sync_frequency', 'daily' );
    add_option( 'converge_sync_enabled', '0' );
}
register_activation_hook( __FILE__, 'converge_activate' );

/**
 * Deactivation hook.
 */
function converge_deactivate() {
    wp_clear_scheduled_hook( 'converge_token_refresh' );
    wp_clear_scheduled_hook( 'converge_job_sync' );
}
register_deactivation_hook( __FILE__, 'converge_deactivate' );
