<?php
/**
 * Frontend widget injection for Converge WordPress plugin.
 * Adds the "Apply by Voice" widget script to job pages.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Converge_Frontend {

    private $auth;

    public function __construct( Converge_Auth $auth ) {
        $this->auth = $auth;

        add_action( 'wp_footer', array( $this, 'inject_widget_script' ) );
    }

    /**
     * Inject the Converge widget.js on the frontend if connected.
     */
    public function inject_widget_script() {
        if ( ! $this->auth->is_connected() ) {
            return;
        }

        $org_slug = get_option( 'converge_org_slug', '' );
        if ( empty( $org_slug ) ) {
            // Fallback to org ID for existing installs that connected before slug was stored
            $org_slug = get_option( 'converge_org_id', '' );
        }
        if ( empty( $org_slug ) ) {
            return;
        }

        $widget_mode = get_option( 'converge_widget_mode', 'float' );
        ?>
        <script
            src="<?php echo esc_url( CONVERGE_API_BASE . '/widget.js' ); ?>"
            data-org="<?php echo esc_attr( $org_slug ); ?>"
            data-mode="<?php echo esc_attr( $widget_mode ); ?>"
            defer
        ></script>
        <?php
    }
}
