<?php
/**
 * Template: Native Analytics page for Converge WordPress plugin.
 * Includes Chart.js visualizations and enhanced metric sections.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$auth = new Converge_Auth();
$connected = $auth->is_connected();
$days = isset( $_GET['days'] ) ? absint( $_GET['days'] ) : 30;
if ( ! in_array( $days, array( 7, 30, 90 ), true ) ) {
    $days = 30;
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e( 'Analytics', 'converge-applybyvoice' ); ?></h1>

    <?php if ( ! $connected ) : ?>
        <div class="converge-card converge-connect-cta">
            <h2><?php esc_html_e( 'Connect Your Account', 'converge-applybyvoice' ); ?></h2>
            <p><?php esc_html_e( 'Connect your Converge account to view analytics.', 'converge-applybyvoice' ); ?></p>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-settings' ) ); ?>" class="button button-primary">
                <?php esc_html_e( 'Connect Account', 'converge-applybyvoice' ); ?>
            </a>
        </div>
    <?php else :
        $api = new Converge_API( $auth );
        $result = $api->get_analytics( $days );

        $base_url = admin_url( 'admin.php?page=converge-analytics' );
    ?>
        <div class="converge-analytics-header">
            <div class="converge-date-tabs">
                <?php foreach ( array( 7, 30, 90 ) as $d ) : ?>
                    <a href="<?php echo esc_url( add_query_arg( 'days', $d, $base_url ) ); ?>"
                       class="converge-date-tab <?php echo $days === $d ? 'active' : ''; ?>">
                        <?php printf( esc_html__( '%d days', 'converge-applybyvoice' ), $d ); ?>
                    </a>
                <?php endforeach; ?>
            </div>
            <button type="button" class="button converge-export-csv" data-days="<?php echo esc_attr( $days ); ?>">
                <span class="dashicons dashicons-download" style="margin-top:3px;"></span>
                <?php esc_html_e( 'Export CSV', 'converge-applybyvoice' ); ?>
            </button>
        </div>

        <?php if ( is_wp_error( $result ) ) : ?>
            <div class="notice notice-error"><p><?php echo esc_html( $result->get_error_message() ); ?></p></div>
        <?php else : ?>

            <!-- Core Metric Cards -->
            <div class="converge-stats-grid converge-stats-5">
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( $result['totalConversations'] ?? 0 ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Total Conversations', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( $result['completedConversations'] ?? 0 ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Completed', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( ( $result['completionRate'] ?? 0 ) . '%' ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Completion Rate', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number">
                        <?php
                        $avg = $result['avgDuration'] ?? 0;
                        if ( $avg > 0 ) {
                            printf( '%d:%02d', floor( $avg / 60 ), $avg % 60 );
                        } else {
                            echo '0:00';
                        }
                        ?>
                    </span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Avg Duration', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( $result['shortlistedCount'] ?? 0 ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Talent Pool', 'converge-applybyvoice' ); ?></span>
                </div>
            </div>

            <!-- Chart.js Visualizations -->
            <div class="converge-chart-grid" id="converge-charts-container"
                 data-days="<?php echo esc_attr( $days ); ?>">
                <div class="converge-chart-card">
                    <h3><?php esc_html_e( 'Conversations Over Time', 'converge-applybyvoice' ); ?></h3>
                    <div class="converge-chart-wrapper">
                        <canvas id="converge-chart-trends"></canvas>
                    </div>
                </div>
                <div class="converge-chart-card converge-chart-small">
                    <h3><?php esc_html_e( 'Status Distribution', 'converge-applybyvoice' ); ?></h3>
                    <div class="converge-chart-wrapper">
                        <canvas id="converge-chart-status"></canvas>
                    </div>
                </div>
                <div class="converge-chart-card converge-chart-small">
                    <h3><?php esc_html_e( 'Entry Channel', 'converge-applybyvoice' ); ?></h3>
                    <div class="converge-chart-wrapper">
                        <canvas id="converge-chart-channel"></canvas>
                    </div>
                </div>
            </div>

            <!-- Enhanced Analytics Sections -->
            <div id="converge-enhanced-analytics">

                <!-- Reliability -->
                <div class="converge-analytics-section" data-section="reliability">
                    <div class="converge-analytics-section-header">
                        <h3>
                            <span class="dashicons dashicons-shield"></span>
                            <?php esc_html_e( 'Reliability', 'converge-applybyvoice' ); ?>
                        </h3>
                        <span class="dashicons dashicons-arrow-down-alt2 converge-section-toggle"></span>
                    </div>
                    <div class="converge-analytics-section-body">
                        <div class="converge-analytics-placeholder">
                            <?php esc_html_e( 'Loading...', 'converge-applybyvoice' ); ?>
                        </div>
                    </div>
                </div>

                <!-- Assessment Distribution -->
                <div class="converge-analytics-section" data-section="assessment">
                    <div class="converge-analytics-section-header">
                        <h3>
                            <span class="dashicons dashicons-chart-bar"></span>
                            <?php esc_html_e( 'Assessment Distribution', 'converge-applybyvoice' ); ?>
                        </h3>
                        <span class="dashicons dashicons-arrow-down-alt2 converge-section-toggle"></span>
                    </div>
                    <div class="converge-analytics-section-body">
                        <div class="converge-analytics-placeholder">
                            <?php esc_html_e( 'Loading...', 'converge-applybyvoice' ); ?>
                        </div>
                    </div>
                </div>

                <!-- Job Performance -->
                <div class="converge-analytics-section" data-section="jobPerformance">
                    <div class="converge-analytics-section-header">
                        <h3>
                            <span class="dashicons dashicons-clipboard"></span>
                            <?php esc_html_e( 'Job Performance', 'converge-applybyvoice' ); ?>
                        </h3>
                        <span class="dashicons dashicons-arrow-down-alt2 converge-section-toggle"></span>
                    </div>
                    <div class="converge-analytics-section-body">
                        <div class="converge-analytics-placeholder">
                            <?php esc_html_e( 'Loading...', 'converge-applybyvoice' ); ?>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Status Breakdown Table (existing) -->
            <?php if ( ! empty( $result['byStatus'] ) ) : ?>
                <div class="converge-card" style="margin-top: 20px;">
                    <h2><?php esc_html_e( 'Status Breakdown', 'converge-applybyvoice' ); ?></h2>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Status', 'converge-applybyvoice' ); ?></th>
                                <th><?php esc_html_e( 'Count', 'converge-applybyvoice' ); ?></th>
                                <th style="width: 50%;"><?php esc_html_e( 'Distribution', 'converge-applybyvoice' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $total = max( $result['totalConversations'], 1 );
                            foreach ( $result['byStatus'] as $row ) :
                                $pct = round( ( $row['count'] / $total ) * 100 );
                            ?>
                                <tr>
                                    <td>
                                        <span class="converge-status-badge converge-status-<?php echo esc_attr( $row['status'] ); ?>">
                                            <?php echo esc_html( ucfirst( str_replace( '_', ' ', $row['status'] ) ) ); ?>
                                        </span>
                                    </td>
                                    <td><?php echo esc_html( $row['count'] ); ?></td>
                                    <td>
                                        <div class="converge-progress-bar">
                                            <div class="converge-progress-fill converge-progress-<?php echo esc_attr( $row['status'] ); ?>" style="width: <?php echo esc_attr( $pct ); ?>%;"></div>
                                        </div>
                                        <span class="converge-progress-label"><?php echo esc_html( $pct . '%' ); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

        <?php endif; ?>
    <?php endif; ?>
</div>
