<?php
/**
 * Template: Native Company Info page for Converge WordPress plugin.
 * Tabbed layout matching the web app: Overview, Benefits, Work, Hiring.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$auth = new Converge_Auth();
$connected = $auth->is_connected();
?>

<div class="wrap">
    <h1><?php esc_html_e( 'Company Info', 'converge-applybyvoice' ); ?></h1>

    <?php if ( ! $connected ) : ?>
        <div class="converge-card converge-connect-cta">
            <h2><?php esc_html_e( 'Connect Your Account', 'converge-applybyvoice' ); ?></h2>
            <p><?php esc_html_e( 'Connect your Converge account to manage company info.', 'converge-applybyvoice' ); ?></p>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-settings' ) ); ?>" class="button button-primary">
                <?php esc_html_e( 'Connect Account', 'converge-applybyvoice' ); ?>
            </a>
        </div>
    <?php else :
        $api = new Converge_API( $auth );
        $result = $api->get_company_info();
        $info = array();

        if ( ! is_wp_error( $result ) && ! empty( $result['data'] ) ) {
            $info = $result['data'];
        }

        // Extract values for the form
        $values_str = '';
        if ( ! empty( $info['company_values'] ) && is_array( $info['company_values'] ) ) {
            $values_str = implode( ', ', array_map( function( $v ) {
                return is_array( $v ) ? ( $v['name'] ?? '' ) : $v;
            }, $info['company_values'] ) );
        }

        $benefits = $info['benefits'] ?? array();
        if ( is_string( $benefits ) ) {
            $benefits = json_decode( $benefits, true ) ?: array();
        }
        $locations = $info['office_locations'] ?? array();
        if ( is_string( $locations ) ) {
            $locations = json_decode( $locations, true ) ?: array();
        }
    ?>
        <?php if ( is_wp_error( $result ) ) : ?>
            <div class="notice notice-error"><p><?php echo esc_html( $result->get_error_message() ); ?></p></div>
        <?php endif; ?>

        <p class="description"><?php esc_html_e( 'This information helps the AI interviewer represent your company accurately during voice conversations.', 'converge-applybyvoice' ); ?></p>

        <!-- Tab Navigation -->
        <div class="converge-company-tabs" id="company-tabs">
            <button type="button" class="converge-company-tab is-active" data-tab="overview">
                <span class="dashicons dashicons-building" style="font-size: 16px; width: 16px; height: 16px;"></span>
                <?php esc_html_e( 'Overview', 'converge-applybyvoice' ); ?>
            </button>
            <button type="button" class="converge-company-tab" data-tab="benefits">
                <span class="dashicons dashicons-heart" style="font-size: 16px; width: 16px; height: 16px;"></span>
                <?php esc_html_e( 'Benefits', 'converge-applybyvoice' ); ?>
            </button>
            <button type="button" class="converge-company-tab" data-tab="work">
                <span class="dashicons dashicons-location" style="font-size: 16px; width: 16px; height: 16px;"></span>
                <?php esc_html_e( 'Work', 'converge-applybyvoice' ); ?>
            </button>
            <button type="button" class="converge-company-tab" data-tab="hiring">
                <span class="dashicons dashicons-groups" style="font-size: 16px; width: 16px; height: 16px;"></span>
                <?php esc_html_e( 'Hiring', 'converge-applybyvoice' ); ?>
            </button>
        </div>

        <form id="converge-company-form">

            <!-- Overview Tab -->
            <div class="converge-tab-panel is-active" data-tab-panel="overview">
                <div class="converge-card" style="border-top: none; border-radius: 0 0 4px 4px;">
                    <div class="converge-kb-field" style="margin-bottom: 16px;">
                        <label for="company_description"><?php esc_html_e( 'Company Description', 'converge-applybyvoice' ); ?></label>
                        <textarea name="company_description" id="company_description" rows="4" class="large-text"><?php echo esc_textarea( $info['company_description'] ?? '' ); ?></textarea>
                    </div>

                    <div class="converge-kb-field" style="margin-bottom: 16px;">
                        <label for="company_mission"><?php esc_html_e( 'Mission Statement', 'converge-applybyvoice' ); ?></label>
                        <textarea name="company_mission" id="company_mission" rows="3" class="large-text"><?php echo esc_textarea( $info['company_mission'] ?? '' ); ?></textarea>
                    </div>

                    <div class="converge-kb-field" style="margin-bottom: 16px;">
                        <label for="company_culture"><?php esc_html_e( 'Company Culture', 'converge-applybyvoice' ); ?></label>
                        <textarea name="company_culture" id="company_culture" rows="3" class="large-text"><?php echo esc_textarea( $info['company_culture'] ?? '' ); ?></textarea>
                    </div>

                    <div class="converge-kb-field" style="margin-bottom: 16px;">
                        <label for="company_values"><?php esc_html_e( 'Company Values', 'converge-applybyvoice' ); ?></label>
                        <input type="text" name="company_values" id="company_values" value="<?php echo esc_attr( $values_str ); ?>" class="large-text">
                        <span class="description"><?php esc_html_e( 'Comma-separated (e.g., Innovation, Integrity, Teamwork)', 'converge-applybyvoice' ); ?></span>
                    </div>

                    <div class="converge-kb-row">
                        <div class="converge-kb-field">
                            <label for="company_size"><?php esc_html_e( 'Company Size', 'converge-applybyvoice' ); ?></label>
                            <?php $size = $info['company_size'] ?? ''; ?>
                            <select name="company_size" id="company_size">
                                <option value=""><?php esc_html_e( 'Select...', 'converge-applybyvoice' ); ?></option>
                                <option value="1-49" <?php selected( $size, '1-49' ); ?>>1-49</option>
                                <option value="50-199" <?php selected( $size, '50-199' ); ?>>50-199</option>
                                <option value="200-999" <?php selected( $size, '200-999' ); ?>>200-999</option>
                                <option value="1000-4999" <?php selected( $size, '1000-4999' ); ?>>1,000-4,999</option>
                                <option value="5000-9999" <?php selected( $size, '5000-9999' ); ?>>5,000-9,999</option>
                                <option value="10000+" <?php selected( $size, '10000+' ); ?>>10,000+</option>
                            </select>
                        </div>
                    </div>

                    <!-- Custom AI Greeting -->
                    <h3 style="margin-top: 24px;"><?php esc_html_e( 'Custom AI Greeting', 'converge-applybyvoice' ); ?></h3>
                    <div class="converge-toggle-row">
                        <div class="converge-toggle-label">
                            <strong><?php esc_html_e( 'Use Custom Greeting', 'converge-applybyvoice' ); ?></strong>
                            <span class="description"><?php esc_html_e( 'Use a custom greeting instead of the default AI-generated one.', 'converge-applybyvoice' ); ?></span>
                        </div>
                        <label class="converge-toggle">
                            <input type="checkbox" name="use_custom_greeting" id="use_custom_greeting" value="1"
                                <?php checked( ! empty( $info['use_custom_greeting'] ) ); ?>>
                            <span class="converge-toggle-slider"></span>
                        </label>
                    </div>
                    <div class="converge-kb-field" style="margin-top: 12px;">
                        <label for="custom_greeting"><?php esc_html_e( 'Greeting Text', 'converge-applybyvoice' ); ?></label>
                        <textarea name="custom_greeting" id="custom_greeting" rows="3" class="large-text"
                                  placeholder="<?php esc_attr_e( 'Hi there! Welcome to [Company Name]...', 'converge-applybyvoice' ); ?>"><?php echo esc_textarea( $info['custom_greeting'] ?? '' ); ?></textarea>
                        <span class="description"><?php esc_html_e( 'This will be the first thing candidates hear. Keep it warm and welcoming.', 'converge-applybyvoice' ); ?></span>
                    </div>
                </div>
            </div>

            <!-- Benefits Tab -->
            <div class="converge-tab-panel" data-tab-panel="benefits">
                <div class="converge-card" style="border-top: none; border-radius: 0 0 4px 4px;">

                    <!-- Health & Insurance -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Health & Insurance', 'converge-applybyvoice' ); ?></h3>
                        <div class="converge-kb-field" style="margin-bottom: 10px;">
                            <label for="benefit_health"><?php esc_html_e( 'Health Insurance', 'converge-applybyvoice' ); ?></label>
                            <input type="text" id="benefit_health" name="benefit_health" value="<?php echo esc_attr( $benefits['health'] ?? '' ); ?>" class="large-text" placeholder="e.g. Full medical coverage, PPO/HMO options">
                        </div>
                        <div class="converge-kb-row">
                            <div class="converge-kb-field">
                                <label for="benefit_dental"><?php esc_html_e( 'Dental', 'converge-applybyvoice' ); ?></label>
                                <input type="text" id="benefit_dental" name="benefit_dental" value="<?php echo esc_attr( $benefits['dental'] ?? '' ); ?>" placeholder="e.g. Full dental coverage">
                            </div>
                            <div class="converge-kb-field">
                                <label for="benefit_vision"><?php esc_html_e( 'Vision', 'converge-applybyvoice' ); ?></label>
                                <input type="text" id="benefit_vision" name="benefit_vision" value="<?php echo esc_attr( $benefits['vision'] ?? '' ); ?>" placeholder="e.g. Vision plan included">
                            </div>
                        </div>
                    </div>

                    <!-- Compensation & Retirement -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Compensation & Retirement', 'converge-applybyvoice' ); ?></h3>
                        <div class="converge-kb-field" style="margin-bottom: 10px;">
                            <label for="benefit_retirement"><?php esc_html_e( '401(k) / Retirement', 'converge-applybyvoice' ); ?></label>
                            <input type="text" id="benefit_retirement" name="benefit_retirement" value="<?php echo esc_attr( $benefits['retirement'] ?? '' ); ?>" class="large-text" placeholder="e.g. 401(k) with 4% company match">
                        </div>
                        <div class="converge-kb-row">
                            <div class="converge-kb-field">
                                <label for="benefit_equity"><?php esc_html_e( 'Equity / Stock Options', 'converge-applybyvoice' ); ?></label>
                                <input type="text" id="benefit_equity" name="benefit_equity" value="<?php echo esc_attr( $benefits['equity'] ?? '' ); ?>" placeholder="e.g. RSUs vesting over 4 years">
                            </div>
                            <div class="converge-kb-field">
                                <label for="benefit_bonus"><?php esc_html_e( 'Bonus Structure', 'converge-applybyvoice' ); ?></label>
                                <input type="text" id="benefit_bonus" name="benefit_bonus" value="<?php echo esc_attr( $benefits['bonus'] ?? '' ); ?>" placeholder="e.g. Annual performance bonus up to 15%">
                            </div>
                        </div>
                    </div>

                    <!-- Time Off -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Time Off', 'converge-applybyvoice' ); ?></h3>
                        <div class="converge-kb-row">
                            <div class="converge-kb-field">
                                <label for="pto_policy"><?php esc_html_e( 'PTO Policy', 'converge-applybyvoice' ); ?></label>
                                <?php $pto = $info['pto_policy'] ?? ''; ?>
                                <select id="pto_policy" name="pto_policy">
                                    <option value=""><?php esc_html_e( 'Select...', 'converge-applybyvoice' ); ?></option>
                                    <option value="unlimited" <?php selected( $pto, 'unlimited' ); ?>><?php esc_html_e( 'Unlimited', 'converge-applybyvoice' ); ?></option>
                                    <option value="flexible" <?php selected( $pto, 'flexible' ); ?>><?php esc_html_e( 'Flexible', 'converge-applybyvoice' ); ?></option>
                                    <option value="fixed" <?php selected( $pto, 'fixed' ); ?>><?php esc_html_e( 'Fixed', 'converge-applybyvoice' ); ?></option>
                                </select>
                            </div>
                            <div class="converge-kb-field">
                                <label for="vacation_days"><?php esc_html_e( 'Vacation Days', 'converge-applybyvoice' ); ?></label>
                                <input type="number" id="vacation_days" name="vacation_days" value="<?php echo esc_attr( $info['vacation_days'] ?? '' ); ?>" min="0" placeholder="e.g. 20">
                            </div>
                            <div class="converge-kb-field">
                                <label for="sick_days"><?php esc_html_e( 'Sick Days', 'converge-applybyvoice' ); ?></label>
                                <input type="number" id="sick_days" name="sick_days" value="<?php echo esc_attr( $info['sick_days'] ?? '' ); ?>" min="0" placeholder="e.g. 10">
                            </div>
                        </div>
                        <div class="converge-kb-field" style="margin-top: 10px;">
                            <label for="parental_leave"><?php esc_html_e( 'Parental Leave', 'converge-applybyvoice' ); ?></label>
                            <input type="text" id="parental_leave" name="parental_leave" value="<?php echo esc_attr( $info['parental_leave'] ?? '' ); ?>" class="large-text" placeholder="e.g. 16 weeks paid parental leave">
                        </div>
                    </div>

                    <!-- Growth & Development -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Growth & Development', 'converge-applybyvoice' ); ?></h3>
                        <div class="converge-kb-field" style="margin-bottom: 10px;">
                            <label for="learning_budget"><?php esc_html_e( 'Learning & Development Budget', 'converge-applybyvoice' ); ?></label>
                            <input type="text" id="learning_budget" name="learning_budget" value="<?php echo esc_attr( $info['learning_budget'] ?? '' ); ?>" class="large-text" placeholder="e.g. $2,000/year for courses and conferences">
                        </div>
                        <div class="converge-kb-field">
                            <label for="career_growth_opportunities"><?php esc_html_e( 'Career Growth Opportunities', 'converge-applybyvoice' ); ?></label>
                            <textarea name="career_growth_opportunities" id="career_growth_opportunities" rows="3" class="large-text"><?php echo esc_textarea( $info['career_growth_opportunities'] ?? '' ); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Work Tab -->
            <div class="converge-tab-panel" data-tab-panel="work">
                <div class="converge-card" style="border-top: none; border-radius: 0 0 4px 4px;">

                    <!-- Remote Work -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Remote Work', 'converge-applybyvoice' ); ?></h3>
                        <div class="converge-kb-row">
                            <div class="converge-kb-field">
                                <label for="remote_work_policy"><?php esc_html_e( 'Policy', 'converge-applybyvoice' ); ?></label>
                                <?php $policy = $info['remote_work_policy'] ?? ''; ?>
                                <select name="remote_work_policy" id="remote_work_policy">
                                    <option value=""><?php esc_html_e( 'Select...', 'converge-applybyvoice' ); ?></option>
                                    <option value="fully_remote" <?php selected( $policy, 'fully_remote' ); ?>><?php esc_html_e( 'Fully Remote', 'converge-applybyvoice' ); ?></option>
                                    <option value="hybrid" <?php selected( $policy, 'hybrid' ); ?>><?php esc_html_e( 'Hybrid', 'converge-applybyvoice' ); ?></option>
                                    <option value="on_site" <?php selected( $policy, 'on_site' ); ?>><?php esc_html_e( 'On-Site', 'converge-applybyvoice' ); ?></option>
                                    <option value="flexible" <?php selected( $policy, 'flexible' ); ?>><?php esc_html_e( 'Flexible', 'converge-applybyvoice' ); ?></option>
                                </select>
                            </div>
                            <div class="converge-kb-field">
                                <label for="work_hours_flexibility"><?php esc_html_e( 'Work Hours', 'converge-applybyvoice' ); ?></label>
                                <input type="text" id="work_hours_flexibility" name="work_hours_flexibility" value="<?php echo esc_attr( $info['work_hours_flexibility'] ?? '' ); ?>" placeholder="e.g. Flexible core hours 10am-3pm">
                            </div>
                        </div>
                        <div class="converge-kb-field" style="margin-top: 10px;">
                            <label for="remote_work_details"><?php esc_html_e( 'Details', 'converge-applybyvoice' ); ?></label>
                            <textarea id="remote_work_details" name="remote_work_details" rows="3" class="large-text" placeholder="<?php esc_attr_e( 'Describe remote work expectations, in-office requirements, etc.', 'converge-applybyvoice' ); ?>"><?php echo esc_textarea( $info['remote_work_details'] ?? '' ); ?></textarea>
                        </div>
                    </div>

                    <!-- Office Locations -->
                    <div class="converge-benefits-card">
                        <h3><?php esc_html_e( 'Office Locations', 'converge-applybyvoice' ); ?></h3>
                        <div id="converge-locations-list">
                            <?php if ( ! empty( $locations ) ) : ?>
                                <?php foreach ( $locations as $idx => $loc ) : ?>
                                    <div class="converge-location-item">
                                        <div class="converge-location-fields">
                                            <input type="text" class="loc-name" value="<?php echo esc_attr( $loc['name'] ?? '' ); ?>" placeholder="<?php esc_attr_e( 'Name (e.g. HQ)', 'converge-applybyvoice' ); ?>">
                                            <input type="text" class="loc-address" value="<?php echo esc_attr( $loc['address'] ?? '' ); ?>" placeholder="<?php esc_attr_e( 'Address', 'converge-applybyvoice' ); ?>" style="flex: 2;">
                                            <label><input type="checkbox" class="loc-hq" value="1" <?php checked( ! empty( $loc['is_hq'] ) ); ?>> <?php esc_html_e( 'HQ', 'converge-applybyvoice' ); ?></label>
                                        </div>
                                        <button type="button" class="converge-location-remove" title="<?php esc_attr_e( 'Remove', 'converge-applybyvoice' ); ?>">&times;</button>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <button type="button" id="converge-add-location" class="button button-small" style="margin-top: 8px;">
                            <?php esc_html_e( '+ Add Location', 'converge-applybyvoice' ); ?>
                        </button>
                        <input type="hidden" name="office_locations" id="converge-locations-data" value="">
                    </div>
                </div>
            </div>

            <!-- Hiring Tab -->
            <div class="converge-tab-panel" data-tab-panel="hiring">
                <div class="converge-card" style="border-top: none; border-radius: 0 0 4px 4px;">
                    <div class="converge-kb-field" style="margin-bottom: 16px;">
                        <label for="interview_process_overview"><?php esc_html_e( 'Interview Process Overview', 'converge-applybyvoice' ); ?></label>
                        <textarea id="interview_process_overview" name="interview_process_overview" rows="4" class="large-text"
                                  placeholder="<?php esc_attr_e( 'Describe your typical hiring process steps...', 'converge-applybyvoice' ); ?>"><?php echo esc_textarea( $info['interview_process_overview'] ?? '' ); ?></textarea>
                        <span class="description"><?php esc_html_e( 'The AI can share this with candidates who ask about next steps.', 'converge-applybyvoice' ); ?></span>
                    </div>

                    <div class="converge-kb-field">
                        <label for="typical_hiring_timeline"><?php esc_html_e( 'Typical Hiring Timeline', 'converge-applybyvoice' ); ?></label>
                        <input type="text" id="typical_hiring_timeline" name="typical_hiring_timeline"
                               value="<?php echo esc_attr( $info['typical_hiring_timeline'] ?? '' ); ?>" class="regular-text"
                               placeholder="<?php esc_attr_e( 'e.g. 2-3 weeks from first interview to offer', 'converge-applybyvoice' ); ?>">
                    </div>
                </div>
            </div>

            <p class="submit">
                <button type="submit" class="button button-primary"><?php esc_html_e( 'Save Changes', 'converge-applybyvoice' ); ?></button>
                <span id="converge-company-save-status" class="converge-save-status"></span>
            </p>
        </form>
    <?php endif; ?>
</div>
