<?php
/**
 * Template: Converge Dashboard (native WP page).
 * Includes usage bar, limit warnings, relative timestamps, and quick actions.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$auth = new Converge_Auth();
$connected = $auth->is_connected();
$org_name = get_option( 'converge_org_name', '' );

// Fetch live stats if connected
$stats = null;
if ( $connected ) {
    $api = new Converge_API( $auth );
    $stats = $api->get_org_summary();
    if ( is_wp_error( $stats ) ) {
        $stats = null;
    }
}
?>

<div class="wrap converge-dashboard">
    <h1><?php esc_html_e( 'Converge — Apply by Voice', 'converge-applybyvoice' ); ?></h1>

    <?php if ( ! $connected ) : ?>
        <div class="converge-card converge-connect-cta">
            <h2><?php esc_html_e( 'Get Started', 'converge-applybyvoice' ); ?></h2>
            <p><?php esc_html_e( 'Connect your Converge account to add voice screening to your job listings.', 'converge-applybyvoice' ); ?></p>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-settings' ) ); ?>" class="button button-primary button-hero">
                <?php esc_html_e( 'Connect Account', 'converge-applybyvoice' ); ?>
            </a>
        </div>
    <?php else : ?>
        <p class="converge-org-name">
            <?php
            printf(
                esc_html__( 'Connected to %s', 'converge-applybyvoice' ),
                '<strong>' . esc_html( $org_name ) . '</strong>'
            );
            ?>
        </p>

        <?php if ( $stats ) :
            $used = $stats['conversationsThisMonth'] ?? 0;
            $limit = $stats['monthlyLimit'] ?? 5;
            $plan_type = $stats['planType'] ?? 'starter';
            $is_limited = $limit > 0 && $limit !== -1;
            $usage_pct = $is_limited ? min( 100, round( ( $used / $limit ) * 100 ) ) : 0;
        ?>

            <!-- Limit Warning Banner -->
            <?php if ( $is_limited && $usage_pct >= 80 ) : ?>
                <div class="converge-limit-warning <?php echo $usage_pct >= 100 ? 'converge-limit-full' : 'converge-limit-approaching'; ?>">
                    <?php if ( $usage_pct >= 100 ) : ?>
                        <span class="dashicons dashicons-warning"></span>
                        <div>
                            <strong><?php esc_html_e( 'Monthly limit reached', 'converge-applybyvoice' ); ?></strong>
                            <p><?php esc_html_e( 'You\'ve used all your conversations this month. Upgrade to Pro for unlimited conversations.', 'converge-applybyvoice' ); ?></p>
                            <button type="button" class="button button-primary converge-billing-checkout">
                                <?php esc_html_e( 'Upgrade to Pro', 'converge-applybyvoice' ); ?>
                            </button>
                        </div>
                    <?php else : ?>
                        <span class="dashicons dashicons-info"></span>
                        <div>
                            <strong><?php esc_html_e( 'Approaching monthly limit', 'converge-applybyvoice' ); ?></strong>
                            <p>
                                <?php
                                printf(
                                    esc_html__( 'You\'ve used %d of %d conversations. Consider upgrading for unlimited access.', 'converge-applybyvoice' ),
                                    intval( $used ),
                                    intval( $limit )
                                );
                                ?>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="converge-stats-grid">
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( $stats['activeJobs'] ?? 0 ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Active Jobs', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number"><?php echo esc_html( $stats['totalCandidates'] ?? 0 ); ?></span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Total Candidates', 'converge-applybyvoice' ); ?></span>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-number">
                        <?php
                        if ( ! $is_limited ) {
                            echo esc_html( $used );
                        } else {
                            echo esc_html( $used . ' / ' . $limit );
                        }
                        ?>
                    </span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Conversations This Month', 'converge-applybyvoice' ); ?></span>
                    <?php if ( $is_limited ) : ?>
                        <div class="converge-usage-bar converge-usage-bar-small">
                            <?php
                            $bar_class = $usage_pct >= 100 ? 'converge-usage-full' : ( $usage_pct >= 80 ? 'converge-usage-warning' : '' );
                            ?>
                            <div class="converge-usage-fill <?php echo esc_attr( $bar_class ); ?>" style="width: <?php echo esc_attr( $usage_pct ); ?>%;"></div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="converge-stat-card">
                    <span class="converge-stat-badge converge-plan-<?php echo esc_attr( $plan_type ); ?>">
                        <?php echo esc_html( ucfirst( $plan_type ) ); ?>
                    </span>
                    <span class="converge-stat-label"><?php esc_html_e( 'Plan', 'converge-applybyvoice' ); ?></span>
                </div>
            </div>

            <!-- Quick Actions Row -->
            <div class="converge-quick-actions">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-jobs' ) ); ?>" class="converge-quick-action-card">
                    <span class="dashicons dashicons-list-view"></span>
                    <span><?php esc_html_e( 'View Jobs', 'converge-applybyvoice' ); ?></span>
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-company' ) ); ?>" class="converge-quick-action-card">
                    <span class="dashicons dashicons-building"></span>
                    <span><?php esc_html_e( 'Company Settings', 'converge-applybyvoice' ); ?></span>
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-analytics' ) ); ?>" class="converge-quick-action-card">
                    <span class="dashicons dashicons-chart-area"></span>
                    <span><?php esc_html_e( 'Analytics', 'converge-applybyvoice' ); ?></span>
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-settings' ) ); ?>" class="converge-quick-action-card">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <span><?php esc_html_e( 'Settings', 'converge-applybyvoice' ); ?></span>
                </a>
            </div>

            <?php if ( ! empty( $stats['recentConversations'] ) ) : ?>
                <div class="converge-card">
                    <h2><?php esc_html_e( 'Recent Conversations', 'converge-applybyvoice' ); ?></h2>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Candidate', 'converge-applybyvoice' ); ?></th>
                                <th><?php esc_html_e( 'Job', 'converge-applybyvoice' ); ?></th>
                                <th><?php esc_html_e( 'Status', 'converge-applybyvoice' ); ?></th>
                                <th><?php esc_html_e( 'When', 'converge-applybyvoice' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ( $stats['recentConversations'] as $conv ) : ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-conversation&conversation_id=' . urlencode( $conv['id'] ) ) ); ?>">
                                            <?php echo esc_html( $conv['candidateName'] ?? 'Unknown' ); ?>
                                        </a>
                                    </td>
                                    <td><?php echo esc_html( $conv['jobTitle'] ?? 'Unknown' ); ?></td>
                                    <td>
                                        <span class="converge-status-badge converge-status-<?php echo esc_attr( $conv['status'] ?? 'unknown' ); ?>">
                                            <?php echo esc_html( ucfirst( $conv['status'] ?? 'unknown' ) ); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="converge-relative-time" data-time="<?php echo esc_attr( $conv['createdAt'] ); ?>">
                                            <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $conv['createdAt'] ) ) ); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

        <?php else : ?>
            <div class="converge-card">
                <p><?php esc_html_e( 'Unable to load dashboard data. Please check your connection.', 'converge-applybyvoice' ); ?></p>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
