<?php
/**
 * Template: Native Jobs page for Converge WordPress plugin.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$auth = new Converge_Auth();
$connected = $auth->is_connected();
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e( 'Jobs', 'converge-applybyvoice' ); ?></h1>
    <a href="<?php echo esc_url( CONVERGE_API_BASE . '/jobs/new' ); ?>" target="_blank" class="page-title-action">
        <?php esc_html_e( 'Create Job', 'converge-applybyvoice' ); ?>
        <span class="dashicons dashicons-external" style="font-size: 14px; line-height: 1.8; width: 14px; height: 14px;"></span>
    </a>
    <hr class="wp-header-end">

    <?php if ( ! $connected ) : ?>
        <div class="converge-card converge-connect-cta">
            <h2><?php esc_html_e( 'Connect Your Account', 'converge-applybyvoice' ); ?></h2>
            <p><?php esc_html_e( 'Connect your Converge account to view and manage your jobs.', 'converge-applybyvoice' ); ?></p>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=converge-settings' ) ); ?>" class="button button-primary">
                <?php esc_html_e( 'Connect Account', 'converge-applybyvoice' ); ?>
            </a>
        </div>
    <?php else :
        $api = new Converge_API( $auth );
        $result = $api->get_jobs();

        if ( is_wp_error( $result ) ) : ?>
            <div class="notice notice-error"><p><?php echo esc_html( $result->get_error_message() ); ?></p></div>
        <?php elseif ( empty( $result['jobs'] ) ) : ?>
            <div class="converge-card">
                <p><?php esc_html_e( 'No jobs yet. Create your first job to start receiving voice applications.', 'converge-applybyvoice' ); ?></p>
                <a href="<?php echo esc_url( CONVERGE_API_BASE . '/jobs/new' ); ?>" target="_blank" class="button button-primary">
                    <?php esc_html_e( 'Create Job', 'converge-applybyvoice' ); ?>
                </a>
            </div>
        <?php else : ?>
            <table class="widefat striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Title', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Location', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Status', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Setup', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Conversations', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Created', 'converge-applybyvoice' ); ?></th>
                        <th><?php esc_html_e( 'Actions', 'converge-applybyvoice' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ( $result['jobs'] as $job ) :
                        $detail_url = admin_url( 'admin.php?page=converge-job-detail&job_id=' . urlencode( $job['id'] ) );
                        $setup_url  = admin_url( 'admin.php?page=converge-job-detail&job_id=' . urlencode( $job['id'] ) . '&tab=setup' );
                        $c = $job['completeness'] ?? array();
                        $configured = $c['configuredCount'] ?? 0;
                        $total      = $c['totalChecks'] ?? 7;
                        $tier       = $c['tier'] ?? 'incomplete';

                        // Tier CSS class
                        $tier_classes = array(
                            'complete'    => 'converge-setup-complete',
                            'recommended' => 'converge-setup-recommended',
                            'essential'   => 'converge-setup-essential',
                            'incomplete'  => 'converge-setup-incomplete',
                        );
                        $tier_class = $tier_classes[ $tier ] ?? 'converge-setup-incomplete';
                    ?>
                        <tr>
                            <td>
                                <strong>
                                    <a href="<?php echo esc_url( $detail_url ); ?>">
                                        <?php echo esc_html( $job['title'] ); ?>
                                    </a>
                                </strong>
                            </td>
                            <td><?php echo esc_html( $job['location'] ?: '—' ); ?></td>
                            <td>
                                <span class="converge-status-badge converge-status-<?php echo esc_attr( $job['status'] ); ?>">
                                    <?php echo esc_html( ucfirst( $job['status'] ) ); ?>
                                </span>
                            </td>
                            <td>
                                <a href="<?php echo esc_url( $setup_url ); ?>" class="converge-setup-indicator <?php echo esc_attr( $tier_class ); ?>">
                                    <span class="dashicons <?php echo $tier === 'complete' ? 'dashicons-yes-alt' : 'dashicons-warning'; ?>"></span>
                                    <?php echo esc_html( $configured . '/' . $total ); ?>
                                </a>
                            </td>
                            <td><?php echo esc_html( $job['conversationCount'] ); ?></td>
                            <td><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $job['createdAt'] ) ) ); ?></td>
                            <td>
                                <a href="<?php echo esc_url( $detail_url ); ?>">
                                    <?php esc_html_e( 'View Candidates', 'converge-applybyvoice' ); ?>
                                </a>
                                |
                                <a href="<?php echo esc_url( $setup_url ); ?>">
                                    <?php esc_html_e( 'Edit', 'converge-applybyvoice' ); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    <?php endif; ?>
</div>
