<?php
/**
 * Converge — Apply by Voice — Uninstall cleanup.
 * Removes all plugin options and post meta on uninstall.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Remove all plugin options
$options = array(
    'converge_access_token',
    'converge_refresh_token',
    'converge_token_expires_at',
    'converge_connected_at',
    'converge_org_name',
    'converge_org_id',
    'converge_org_slug',
    'converge_sync_enabled',
    'converge_widget_mode',
    'converge_sync_frequency',
    'converge_last_sync',
    'converge_last_sync_count',
);

foreach ( $options as $option ) {
    delete_option( $option );
}

// Remove Converge job ID from all post meta
global $wpdb;
$wpdb->delete( $wpdb->postmeta, array( 'meta_key' => '_converge_job_id' ) );

// Clear scheduled cron events
wp_clear_scheduled_hook( 'converge_token_refresh' );
wp_clear_scheduled_hook( 'converge_job_sync' );
